/*!
 * 
 * 4DView Pro library 0.0.0
 * 
 * Copyright(c) 4D SAS.  All rights reserved.
 * 
 * 4D (the "Software") and the corresponding source code remain
 * the exclusive property of 4D and/or its licensors and are protected by national
 * and/or international legislations.
 * 
 * This file is part of the source code of the Software provided under the relevant
 * 4D License Agreement available on http://www.4D.com/license whose compliance
 * constitutes a prerequisite to any use of this file and more generally of the
 * Software and the corresponding source code.
 * 
 */

Utils.addCommand('import-json', function (doc) {
  Utils.currentDocument = {};

  if (doc.version) Utils.currentDocument.d4Version = doc.version;
  if (doc.dateCreation) Utils.currentDocument.d4DateCreation = doc.dateCreation;
  if (doc.dateModified) Utils.currentDocument.d4DateModified = doc.dateModified;
  if (doc.meta) Utils.currentDocument.d4Meta = doc.meta;

  Utils.spread.suspendPaint();

  try {

    if (useRibbon) {
      Utils.spread.fromJSON(doc.spreadJS);
      designer.ribbon.updateRibbonBarStyle();
    } else if (useToolbar) {
      importJson(doc.spreadJS);
    } else {
      Utils.spread.fromJSON(doc.spreadJS);
    }
  } catch (e) { }

  Utils.spread.resumePaint();
});

Utils.addCommand('export-json', function (params) {
  let doc = {};
  let document = Utils.currentDocument;

  if (document.d4Version) doc.version = document.d4Version;
  if (document.d4DateCreation) doc.dateCreation = document.d4DateCreation;
  if (document.d4DateModified) doc.dateModified = document.d4DateModified;
  if (document.d4Meta) doc.meta = document.d4Meta;

  let serializationOption = {};
  if (params["valuesOnly"] != null)
    serializationOption.ignoreFormula = params.valuesOnly;

  doc.spreadJS = Utils.spread.toJSON(serializationOption);

  return doc;
});

Utils.addCommand('export-excel', function (params) {
  let serializationOption = {};
  if (params["valuesOnly"] != null)
    serializationOption.ignoreFormula = params.valuesOnly;

  let json = Utils.spread.toJSON(serializationOption);

  let options = {};
  if (params["password"] != null)
    options.password = params.password;

  var excelIO = new GC.Spread.Excel.IO();
  excelIO.save(json,
    function (blob) {
      var reader = new FileReader();
      reader.onloadend = function () {
        params.content = reader.result.substr(reader.result.indexOf(',') + 1);
        $4d._vp_callback(params);
      }
      reader.readAsDataURL(blob);
    },
    function (e) {
      params.error = e;
      $4d._vp_callback(params);
    },
    options);
});

Utils.addCommand('import-excel', function (params) {
  var blob = Utils.b64ToBlob(params.content);

  let options = {};
  if (params["password"] != null)
    options.password = params.password;

  var excelIO = new GC.Spread.Excel.IO();
  excelIO.open(blob,
    function (json) {

      Utils.spread.suspendPaint();

      try {
        if (useRibbon) {
          Utils.spread.fromJSON(json);
          designer.ribbon.updateRibbonBarStyle();
        }
        else if (useToolbar) {
          importJson(doc.spreadJS);
        } else {
          Utils.spread.fromJSON(json);
        }
      } catch (e) {
        params.error = e;
        $4d._vp_callback(params);
      }

      Utils.spread.resumePaint();

      $4d._vp_callback(params);
    },
    function (e) {
      params.error = e;
      $4d._vp_callback(params);
    },
    options);
});

Utils.addCommand('export-pdf', function (params) {
  var sheetIndex = Utils.resolveSheetIndex(params.sheetIndex);

  var options = null;
  if (('pdfOptions' in params) && (typeof (params.pdfOptions) === 'object')) {
    options = params.pdfOptions;
  }

  Utils.spread.savePDF(function (blob) {
    var reader = new FileReader();
    reader.onloadend = function () {
      params.content = reader.result.substr(reader.result.indexOf(',') + 1);
      $4d._vp_callback(params);
    }
    reader.readAsDataURL(blob);
  },
    function (e) {
      params.error = e;
      $4d._vp_callback(params);
    },
    options,
    sheetIndex);
});

